//
//  MCActionArgumentContainer.h
//  MCFoundation
//
//  Created by aj on Thu Oct 18 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum {
	MCUseNoArgs = 0,
	MCUseOneArg = 1,
	MCUseBothArgs = 2
} MCUseArgs;

@interface MCActionArgumentContainer : NSObject {
	id firstObject;
	id secondObject;
	int useArgs;
	SEL selector;

}

+ (MCActionArgumentContainer *)actionArgumentUsingAction:(SEL)aSel 
	object:(id)anObject 
	object:(id)anotherObject 
	mode:(MCUseArgs)aMode;

- (void)setAction:(SEL)aSel;
- (SEL)action;

- (void)setMode:(MCUseArgs)aMode;
- (MCUseArgs)mode;

- (void)setFirstObject:(id)anObject;
- (id)firstObject;

- (void)setSecondObject:(id)anObject;
- (id)secondObject;

// invokes the action with args (depending on the the mode), 
// returns the value of performSelector or return nil if 
// the target does not respond to the selector
- (id)invokeOnTarget:(id)aTarget;

@end
